<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Venta extends Model
{
    protected $table = 'ventas';
    protected $primaryKey = 'id_venta';

    protected $fillable = [
        'id_venta', 'id_usuario','id_local', 'id_cliente', 'id_nota', 'id_tipo_comprobante', 'serie_comprobante', 'numero_comprobante', 'nombre_comprobante', 'fecha_venta', 'tipo_pago', 'fecha_pago', 'total_venta', 'igv_total', 'gravado_total', 'descuento_global', 'observacion', 'contingencia',  'numero_cuotas', 'estado_envio', 'mensaje_envio', 'estado'
    ];

    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }
    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }
    public function cliente()
    {
        return $this->belongsTo('App\Models\Cliente', 'id_cliente');
    }
    public function tipo_comprobante()
    {
        return $this->belongsTo('App\Models\TipoComprobante', 'id_tipo_comprobante');
    }
    public function nota()
    {
        return $this->belongsTo('App\Models\Nota', 'id_nota');
    }

}
