<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGuiaRemisionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('guia_remision', function (Blueprint $table) {
            $table->integer('id_guia_remision')->autoIncrement();
            $table->integer('id_usuario');
            $table->integer('id_local');
            $table->integer('id_venta')->nullable();
            $table->integer('id_cliente')->nullable();
            $table->integer('id_tipo_comprobante')->nullable();
            $table->string('serie_guia', 5)->nullable();
            $table->integer('numero_guia')->nullable();
            $table->string('nombre_guia', 20)->nullable();
            $table->date('fecha_emision')->nullable();
            $table->date('fecha_traslado')->nullable();
            $table->string('motivo', 50)->nullable(); 
            $table->string('punto_partida', 200)->nullable();    
            $table->string('punto_llegada', 200)->nullable();  
            $table->string('nombre_transportista', 200)->nullable();
            $table->string('documento_transportista', 15)->nullable(); 
            $table->string('licencia', 20)->nullable(); 
            $table->string('marca_placa', 50)->nullable();
            $table->string('peso', 10)->nullable(); 
            $table->string('observacion', 200)->nullable();
            $table->string('estado_envio', 15)->nullable(); //REGISTRADO, ACEPTADO, NO ENVIADO, RECHAZADO
            $table->string('mensaje_envio', 500)->nullable(); 
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_local')->references('id_local')->on('local');   
            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios');    
            $table->foreign('id_venta')->references('id_venta')->on('ventas');  
            $table->foreign('id_cliente')->references('id_cliente')->on('clientes');  
            $table->foreign('id_tipo_comprobante')->references('id_tipo_comprobante')->on('tipo_comprobante');  

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('guia_remision');
    }
}
