<?php


require('fpdf/fpdf.php');


class PDF_JavaScript extends FPDF {

    var $javascript;
    var $n_js;

    function IncludeJS($script) {
        $this->javascript=$script;
    }

    function _putjavascript() {
        $this->_newobj();
        $this->n_js=$this->n;
        $this->_out('<<');
        $this->_out('/Names [(EmbeddedJS) '.($this->n+1).' 0 R]');
        $this->_out('>>');
        $this->_out('endobj');
        $this->_newobj();
        $this->_out('<<');
        $this->_out('/S /JavaScript');
        $this->_out('/JS '.$this->_textstring($this->javascript));
        $this->_out('>>');
        $this->_out('endobj');
    }

    function _putresources() {
        parent::_putresources();
        if (!empty($this->javascript)) {
            $this->_putjavascript();
        }
    }

    function _putcatalog() {
        parent::_putcatalog();
        if (!empty($this->javascript)) {
            $this->_out('/Names <</JavaScript '.($this->n_js).' 0 R>>');
        }
    }
}

class PDF_AutoPrint extends PDF_JavaScript
{
    function AutoPrint($dialog=false)
    {
        //Open the print dialog or start printing immediately on the standard printer
        $param=($dialog ? 'true' : 'false');
        $script="print($param);";
        $this->IncludeJS($script);
    }

    function AutoPrintToPrinter($server, $printer, $dialog=false)
    {
        $script = "document.contentWindow.print();";
        $this->IncludeJS($script);
    }
}




    /*$pdf = new PDF_AutoPrint();
    $pdf->AddPage();
    $pdf->SetFont('Arial', '', 20);
    $pdf->Text(90, 50, 'Print me!');
    $pdf->AutoPrint(true);
    $pdf->Output();*/



    $pdf=new PDF_AutoPrint('P','cm','Letter');
    $pdf->image("../public/img/logo_empresa.jpg",1.6, 0.2 , 4.2, 1.5); // x , y, ancho, alto
    $pdf->AutoPrint(true);
    $pdf->Output($NomArchPDF, 'I'); // Se muestra el documento .PDF en el navegador.    

?>