$(function () {

	/******************************************************************************/
	/* start: valida formulario de ventas
	/******************************************************************************/

    $('#frmNuevo').form({
    	keyboardShortcuts: false,
    	fields: {
		    id_local_origen: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },

		    id_local_destino: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },

		    descripcion: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },

		    flete: {
		        rules: [
			        { type : 'empty', prompt : 'Complete este campo'},
			        { type   : 'regExp[/^[0-9]+([\.]{1}[0-9]+)?$/]', prompt : 'Ingrese un valor valido'},
		        ]
		    },
    	},
    	inline : true,
	});

  	$('.btn_registrar').on('click', function() {


  		var count=$("#tbody tr:first > td").length;
    	if (count > 0) {
    		if (!cantidadVacia() && numeroValido()) {
	    		if ($('#frmNuevo').form('is valid')) 
	    		{
		  			if ($("select[name='id_local_origen']").val() == $("select[name='id_local_destino']").val()) {
		    			swal("El local de partida ", "y el local de llegada no pueden ser el mismo", "warning");
					} else {
						$('#register_modal').modal({
			  				closable: false,
					    	onApprove : function() {
					    		sendForm();
						    }
				  		}).modal('show'); 
					} 
				} else {
					$('#frmNuevo').form('validate form');
				}
			} else {
				swal("Algunas cantidades", "son incorrectas, por favor verifique", "warning");
			}	
		} else {
			swal("Por favor", "agregue algun producto a la lista", "warning");
		}

  	});	

  	function sendForm() {

	    var data = $('#frmNuevo').serialize();
	 	
        $.requestApi('/traslado/registrar', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve, true, APP_URL+'/traslado/detalles/'+resolve.id_traslado);
	        }
	    });
  
        return false;
	};


	$('[name="id_local_origen"]').change(function() {
		quitarFilas();
	});

    /*********************************************************************************************************/
	/* CARGAR PRODUCTOS DE LOCAL ORIGEN
	/*********************************************************************************************************/  	
	$('.btn_buscar_producto').on('click', function() {

		if ($("select[name='id_local_origen']").val() == '') {
    		swal("Por favor", "seleccione el local de partida", "warning");
		} else {
			$("#loader_producto").removeClass('disabled');
			$("#loader_producto").addClass('active');
	  		$('#buscar_producto_modal').modal('show'); 
	  		cargarProductos(); 
	  		$('#buscar_producto').val('');

		}
  	});	

  	/*********************************************************************************************************/
	/* modal mostrar todos los productos
	/*********************************************************************************************************/
	function cargarProductos() {
        $._requestApi('/producto_local/getAllLocal', { 'id_local' : $("select[name='id_local_origen']").val() }, 'GET', function (resolve) {
	        if (resolve) {
	        	var datos = [];
                for( var i=0; i< resolve.length; i++ ){
                    resolve[i]['i'] = i+1;
                    if(resolve[i]){
                        datos.push(renderProductos(resolve[i]));
                    }
                }
                $('#tbody_productos').html(datos.join(''));
	        	$("#loader_producto").removeClass('active');
				$("#loader_producto").addClass('disabled');

	    	}
	    });
	    
  	};
	
	function buscarNombreProducto(producto) {
        $._requestApi('/producto_local/getByNombreLocal', {'search' : producto, id_local : $("select[name='id_local_origen']").val() }, 'GET', function (resolve) {
	        if (resolve) {
	        	var datos = [];
	        	var j = 0;
                for( var i=0; i< resolve.length; i++ ){
                    if (resolve[i] != null) {
	                    resolve[i]['i'] = j+1;
	                    datos.push(renderProductos(resolve[i]));
	                    j++;
	                }
                }
                $('#tbody_productos').html(datos.join(''));
	        	$("#btn_buscar_prod").removeClass('loading');
	        }
	       
	    });
  	};

	$('#buscar_producto').on('keypress', function(e){
	    if (e.keyCode == 13){
	    	$("#btn_buscar_prod").addClass('loading');
	    	var producto = $('#buscar_producto').val();
    		buscarNombreProducto(producto);
    	}	
	});

	$('#btn_buscar_prod').on('click', function() {
		$("#btn_buscar_prod").addClass('loading');
    	var producto = $('#buscar_producto').val();
    	buscarNombreProducto(producto);
  	});


    $('body').on('click', '.btn_seleccionar_producto', function(){ 
    	var id = $(this).data("id");
    	$("#loader_busqueda").removeClass('disabled');
		$("#loader_busqueda").addClass('active');
        $._requestApi('/producto_local/getByIdLocal', {id_producto : id, id_local : $("select[name='id_local_origen']").val()   }, 'GET', function (resolve) {
	        if (resolve) {
	        	if (resolve.id_producto) {
		        	agregarTabla(resolve);	
		        }
		        $("#loader_busqueda").removeClass('active');
				$("#loader_busqueda").addClass('disabled');
				//$('#buscar_producto_modal').modal('hide'); 
	        }	
	    });
  	});

  	/*********************************************************************************************************/
	/* renderizar productos en table
	/*********************************************************************************************************/

    function agregarTabla(data) {
  		if (verificaExite(data.id_producto)) {
  			cant = parseFloat($('#cant'+data.id_producto_local).val());
  			$('#cant'+data.id_producto_local).val(cant + 1);

  		} else {
  			agregarFila(data);
  		}
        
  	}

  	function agregarFila(data) {

		var nuevoProducto=''+
            '<tr class="rows" id="'+data.id_producto+'">'+
                '<td>'+(data.producto.codigo_barras !== null ? data.producto.codigo_barras : 'Sin Codigo')+'</td>'+
                '<td><input type="hidden" name="id_producto[]" value="'+data.id_producto+'"/>'+data.producto.nombre+' '+(data.producto.descripcion !== null ? data.producto.descripcion : '')+'</td>'+
                '<td>'+data.producto.tipo_presentacion.nombre+'</td>'+
                '<td>'+data.producto.unidad_medida.nombre+'</td>'+
                '<td>'+data.producto.precio+'</td>'+
                '<td class="warning"><input type="text" name="cantidad[]" class="cant '+data.id_producto_local+'" id="cant'+data.id_producto_local+'" value="1" size="1"></td>'+
                '<td ><div class="ui mini vertical animated red button" onclick="quitarTabla(this)" title="Quitar de la lista"><div class="hidden content">Quitar</div><div class="visible content"><i class="times icon"></i></div></div></td>'+
            '</tr>';
          
        $("#tbody").append(nuevoProducto);

  	}


});


/*********************************************************************************************************/
/* funciones de busqueda de productos
/*********************************************************************************************************/
function verificaExite(id) {
	exist = false;
	$('#tbody tr').each(function() {
    	if (this.id == id) {
    		exist = true;
    	}
  	});

	return exist;
}

function quitarTabla(elem) {
    var elementoEliminar=$(elem).parent().parent();
    $(elementoEliminar).remove();
}

function quitarFilas() {
	var n = 0;
	$("#tbody tr").each(function(){
		n++;
	});
	for(var i = n-1; i > -1; i--){
		$("#tbody tr:eq('"+i+"')").remove();
	};
}



function cantidadVacia() {
	var vacio = false;
	var i = 0;
	var cant = document.getElementsByName("cantidad[]");
	$('#tbody tr').each(function() {
    	if (cant[i].value == '') {
    		vacio = true;
    	}
    	i++;
  	});

	return vacio;
}

function numeroValido() {
	var valido = true;
	var i = 0;
	var expresion=/^[0-9]+([\.]{1}[0-9]+)?$/;
	var cant = document.getElementsByName("cantidad[]");
	$('#tbody tr').each(function() {
    	if (expresion.test(cant[i].value) != true) {
    		valido = false;
    	}
    	i++;
  	});
	return valido;
}

function renderProductos(resolve){
	var arr = [];
    arr = [
        '<tr data-table="'+resolve.id_producto+'">',
            '<td>',resolve.i,'</td>',
            '<td>',resolve.producto.codigo_barras,'</td>',
            '<td>',resolve.producto.nombre,' ',resolve.producto.descripcion,'</td>',
            '<td>',resolve.producto.tipo_presentacion.nombre,'</td>',
            '<td>',resolve.producto.unidad_medida.nombre,'</td>',
            '<td>',resolve.producto.precio,'</td>',
            '<td>', (resolve.stock > 1000000 ? (resolve.stock - 1000000).toFixed(2) : "0") ,'</td>',
            '<td><div class="ui mini vertical animated positive button btn_seleccionar_producto" title="Seleccionar este producto" data-id="',resolve.id_producto,'" data-stock="',resolve.stock,'" data-precio="',resolve.producto.precio,'"><div class="hidden content">Elegir</div><div class="visible content"><i class="check icon"></i></div></div></td>',
        '</tr>',
    ];
    return arr.join(''); 
}

