<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REALIZAR UNA VENTA</h4>
            
            <form class="ui form" id="frmNuevo" autocomplete="off"> 
                
                <div class="inline four fields">
                    <div class="ten wide field">
                        <div class="ui toggle checkbox" data-tooltip="Habilitar" data-position="top left" data-inverted="">
                            <label>¿Emitir Guia de Remisión?</label>
                            <input type="checkbox" id="guia_remision">
                        </div>
                    </div>

                    <div class="field datos_comprobante" >
                        <input type="hidden" id="tipo_comprobante" name="id_tipo_comprobante" value="1">
                        <input type="hidden" id="tipo_documento" name="id_tipo_documento" value="1">

                        <div class="ui fluid tiny black button pointing dropdown item" id="select_comprobante_venta">
                            <span class="text">FACTURA</span><i class="dropdown icon"></i>
                            <div class="menu border_shadow">
                                <?php $__currentLoopData = $tipo_comprobante; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="item" data-value="<?php echo e($data->id_tipo_comprobante); ?>"><?php echo e($data->nombre); ?></div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                            </div>
                        </div>
  
                        <div class="ui large white label" id="serie_comprobante"><?php echo e($serie); ?></div>-
                        <div class="ui large white label" id="numero_comprobante"><?php echo e($numero); ?></div>             
                    </div>

                    <div class="two wide field"></div>
                </div>
                <br>

                <div class="three fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label" id="nomb">Razon Social</div>
                    </div>
                    <div class="eleven wide field">
                        <select class="ui small search selection dropdown" name="id_cliente">
                            <option value="">Buscar...</option>
                            <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                               <option value="<?php echo e($data->id_cliente); ?>" data-doc="<?php echo e($data->numero_documento); ?>" data-dir="<?php echo e($data->direccion); ?>"><?php echo e($data->nombre); ?> (<?php echo e($data->numero_documento); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                        </select> 
                    </div>
                    <div class="two wide field">
                        <div class="ui fluid small green button btn_nuevo_cliente" title="Clic para registrar nuevo"><i class="plus icon"></i>NUEVO</div>
                    </div>
                </div>

                <div class="four fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label" id="tipo_doc">RUC</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui disabled small input" id="doc_dis">
                            <input type="text" name="numero_documento" maxlength="11">
                        </div> 
                    </div>
                    <div class="two wide field">
                        <div class="ui fluid large white label">Dirección</div>
                    </div>
                    <div class="six wide field">
                        <div class="ui disabled small input" id="dir_dis">
                            <input type="text" name="direccion" maxlength="100" oninput="$.upperCase(this)">
                        </div> 
                    </div>
                </div>

                <div class="five fields">
                    <div class="three wide field">
                        <div class="ui fluid large white label">Fecha de Venta</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input">
                            <input type="text" class="fecha hasDate" name="fecha_venta" >
                        </div> 
                    </div>
                    <div class="two wide field">
                        <div class="ui fluid large white label">Tipo Pago</div>
                    </div>
                    <div class="six wide field">
                        <select class="ui fluid small input dropdown" name="tipo_pago">
                            <option value="EFECTIVO">Pago en Efectivo</option>
                            <option value="CREDITO">Venta al Credito</option>
                            <option value="TARJETA">Pago con Tarjeta</option>
                        </select> 
                    </div>
                    <div class="two wide field" id="fecha_pago" style="visibility: hidden;">
                        <div class="ui small input">
                            <input type="text" class="fecha_fut" name="fecha_pago" placeholder="Fecha Pago">
                        </div> 
                    </div>
                </div>
               
                <br>
                <div class="ui divider"></div>  
                <br>
                <div class="four fields">
                    <div class="two wide field">
                        <div class="ui fluid large white label">Producto</div>
                    </div>
                    <div class="eleven wide field">
                        <select class="ui small search selection dropdown" name="id_prod">
                            <option value="">Buscar...</option>
                            <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                               <option value="<?php echo e($data->id_producto); ?>"><?php echo e($data->producto->nombre); ?> - <?php echo e($data->producto->codigo_barras); ?> (<?php echo e($data->producto->tipo_presentacion->nombre); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                        </select> 
                    </div>
                    <div class="three wide field">
                        <div class="ui fluid small teal button btn_agregar_producto" title="Clic para añadir a la lista"><i class="arrow down icon"></i>AÑADIR A LISTA</div>
                    </div>
                    
                    
                </div>

                <br>
                    
                <table class="ui celled table">
                    <thead>
                        <tr>
                            <th class="center aligned">Producto</th>
                            <th class="center aligned" data-tooltip="Unidad de medida del producto" data-position="top center" data-inverted="">Und.</th>
                            <th class="center aligned" data-tooltip="Cantidad disponible para vender" data-position="top center" data-inverted="">Stock</th>
                            <th class="center aligned" data-tooltip="Cantidad a vender" data-position="top center" data-inverted="">Cant.</th>
                            <th class="center aligned">Precio S/</th>
                            <th class="center aligned" data-tooltip="Monto para descuento" data-position="top center" data-inverted="">Desc. S/</th>
                            
                            <th class="center aligned">Subtotal S/</th>
                            <th class="center aligned">Acción</th>
                        </tr>
                    </thead>
                    <tbody id="tbody"></tbody>
                </table>

                <div class="form_footer">
                    <div class="ui disabled labeled small input">
                        <label class="ui label">TOTAL</label>
                        <input type="text" name="total_venta" id="total_venta" size="4" style="width: 0%">
                    </div> 
                    <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>REGISTRAR VENTA</div>
                </div>

            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="circular inverted white dollar sign icon"></i>Registrar Venta</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea realizar la venta de estos productos?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar venta"> <i class="checkmark icon"></i>Registrar</div>
        </div>
    </div>
    <!--end register modal -->

    <!--start nuevo cliente modal -->
    <div class="ui standard small modal" id="nuevo_cliente_modal">
        <div class="header">Registrar Nuevo Cliente</div>
        <div class="content">
            <form class="ui form" id="frmNevoCliente" autocomplete="off">
                <div class="field">
                    <div class="field">
                        <label>Nombre / Razon Social</label>
                        <div class="ui small input ">
                          <input type="text" name="nombre" maxlength="200" oninput="$.upperCase(this)">
                        </div>
                    </div>
                </div>
                
                <div class="two fields">
                    <div class="field">
                        <label>Tipo de Documento</label>
                        <select class="ui small input dropdown" name="id_tipo_documento">
                            <option value="">Seleccione</option>
                             <?php $__currentLoopData = $tipo_documento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($tipo->id_tipo_documento); ?>"><?php echo e($tipo->nombre); ?></option>
                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>  
                    </div>
                    <div class="field">
                        <label>Numero de Documento</label>
                        <div class="ui small input ">
                          <input type="text" name="numero_documento" maxlength="11">
                        </div>
                    </div>
                </div> 

                <div class="two fields">
                    <div class="field">
                        <label>Direccion</label>
                        <div class="ui small input ">
                          <input type="text" name="direccion" maxlength="100" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="field">
                        <label>Telefono</label>
                        <div class="ui small input ">
                          <input type="text" name="telefono"  maxlength="15">
                        </div>
                    </div>
                </div>
                <div class="two fields">
                    <div class="field">
                        <label>Email</label>
                        <div class="ui small input ">
                          <input type="text" name="email" maxlength="50">
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <div class="ui right floated primary button btn_registrar_cliente"><i class="check icon"></i>REGISTRAR</div>
        </div>
    </div>
    <!--end nuevo cliente  modal -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/venta/nuevo.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>